#property indicator_chart_window
#property indicator_buffers 6
#property indicator_color1 Yellow
#property indicator_color2 Yellow
#property indicator_color3 Red
#property indicator_color4 Red
#property indicator_color5 Blue
#property indicator_color6 Blue

extern int MAPeriod = 7;
extern int MAMethod = 1;
extern int BBPeriod = 15;
extern int BBDeviation = 1;
extern int BBShift = 1;

double upmax[], upmin[], dnmax[], dnmin[], max[], min[];

int init () {
  IndicatorBuffers (6);
  SetIndexStyle (0, DRAW_HISTOGRAM, STYLE_SOLID, 2);
  SetIndexBuffer (0, max);
  SetIndexStyle (1, DRAW_HISTOGRAM, STYLE_SOLID, 2);
  SetIndexBuffer (1, min);
  SetIndexStyle (2, DRAW_HISTOGRAM, STYLE_SOLID, 2);
  SetIndexBuffer (2, dnmax);
  SetIndexStyle (3, DRAW_HISTOGRAM, STYLE_SOLID, 2);
  SetIndexBuffer (3, dnmin);
  SetIndexStyle (4, DRAW_HISTOGRAM, STYLE_SOLID, 2);
  SetIndexBuffer (4, upmax);
  SetIndexStyle (5, DRAW_HISTOGRAM, STYLE_SOLID, 2);
  SetIndexBuffer (5, upmin);
  return (0);
}

int deinit () {
  return (0);
}

int start () {
  double ma1, ma2, bbu, bbl;
  int c = IndicatorCounted ();

  if (c > 0) {
    c --;
  }

  int n = Bars - c;

  for (int i = 0; i < n; i ++) {
    ma1 = iMA (Symbol (), Period (), MAPeriod, 0, MAMethod, PRICE_CLOSE, i);
    ma2 = iMA (Symbol (), Period (), 21, 0, MODE_SMA, PRICE_CLOSE, i);
    bbu = iBands (Symbol (), Period (), BBPeriod, BBDeviation, BBShift,
      PRICE_CLOSE, MODE_UPPER, i);
    bbl = iBands (Symbol (), Period (), BBPeriod, BBDeviation, BBShift,
      PRICE_CLOSE, MODE_LOWER, i);
    max[i] = MathMax (bbu, MathMax (ma1, ma2));
    min[i] = MathMin (bbl, MathMin (ma1, ma2));

    if (ma1 > ma2) {
      upmax[i] = MathMax (ma1, ma2);
      upmin[i] = MathMin (bbl, MathMin (ma1, ma2));
      dnmax[i] = EMPTY_VALUE;
      dnmin[i] = EMPTY_VALUE;
    } else {
      dnmax[i] = MathMax (bbu, MathMax (ma1, ma2));
      dnmin[i] = MathMin (ma1, ma2);
      upmax[i] = EMPTY_VALUE;
      upmin[i] = EMPTY_VALUE;
    }
  }

  return (0);
}
